/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.analysis.CashFlow;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;
import java.util.ArrayList;
import java.util.List;

public class MaximumDrawdownCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, List<Trade> trades) {
        Decimal maximumDrawdown = Decimal.ZERO;
        Decimal maxPeak = Decimal.ZERO;
        CashFlow cashFlow = new CashFlow(series, trades);
        for (int i = series.getBegin(); i <= series.getEnd(); ++i) {
            Decimal drawdown;
            Decimal value = cashFlow.getValue(i);
            if (value.isGreaterThan(maxPeak)) {
                maxPeak = value;
            }
            if (!(drawdown = maxPeak.minus(value).dividedBy(maxPeak)).isGreaterThan(maximumDrawdown)) continue;
            maximumDrawdown = drawdown;
        }
        return maximumDrawdown.toDouble();
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        trades.add(trade);
        return this.calculate(series, trades);
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 < criterionValue2;
    }
}

