/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;
import java.util.List;

public class TotalProfitCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, List<Trade> trades) {
        double value = 1.0;
        for (Trade trade : trades) {
            value *= this.calculateProfit(series, trade);
        }
        return value;
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        return this.calculateProfit(series, trade);
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }

    private double calculateProfit(TimeSeries series, Trade trade) {
        Decimal profit = Decimal.ONE;
        if (trade.isClosed()) {
            Decimal exitClosePrice = series.getTick(trade.getExit().getIndex()).getClosePrice();
            Decimal entryClosePrice = series.getTick(trade.getEntry().getIndex()).getClosePrice();
            profit = trade.getEntry().isBuy() ? exitClosePrice.dividedBy(entryClosePrice) : entryClosePrice.dividedBy(exitClosePrice);
        }
        return profit.toDouble();
    }
}

