/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.AnalysisCriterion;
import eu.verdelhan.ta4j.Operation;
import eu.verdelhan.ta4j.OperationType;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;
import java.util.ArrayList;
import java.util.List;

public class VersusBuyAndHoldCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion criterion;

    public VersusBuyAndHoldCriterion(AnalysisCriterion criterion) {
        this.criterion = criterion;
    }

    @Override
    public double calculate(TimeSeries series, List<Trade> trades) {
        ArrayList<Trade> fakeTrades = new ArrayList<Trade>();
        fakeTrades.add(new Trade(new Operation(series.getBegin(), OperationType.BUY), new Operation(series.getEnd(), OperationType.SELL)));
        return this.criterion.calculate(series, trades) / this.criterion.calculate(series, fakeTrades);
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        trades.add(trade);
        return this.calculate(series, trades);
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (").append(this.criterion).append(')');
        return sb.toString();
    }
}

