/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.AbstractIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CachedIndicator<T>
extends AbstractIndicator<T> {
    private final List<T> results = new ArrayList<T>();
    private int highestResultIndex = -1;

    public CachedIndicator(TimeSeries series) {
        super(series);
    }

    public CachedIndicator(Indicator indicator) {
        this(indicator.getTimeSeries());
    }

    @Override
    public T getValue(int index) {
        T result;
        TimeSeries series = this.getTimeSeries();
        if (series == null) {
            return this.calculate(index);
        }
        int removedTicksCount = series.getRemovedTicksCount();
        int maximumResultCount = this.getTimeSeries().getMaximumTickCount();
        if (index < removedTicksCount) {
            this.log.trace("{}: result from tick {} already removed from cache, use {}-th instead", new Object[]{this.getClass().getSimpleName(), index, removedTicksCount});
            this.increaseLengthTo(removedTicksCount, maximumResultCount);
            this.highestResultIndex = removedTicksCount;
            result = this.results.get(0);
            if (result == null) {
                result = this.calculate(removedTicksCount);
                this.results.set(0, result);
            }
        } else {
            this.increaseLengthTo(index, maximumResultCount);
            if (index > this.highestResultIndex) {
                this.highestResultIndex = index;
                result = this.calculate(index);
                this.results.set(this.results.size() - 1, result);
            } else {
                int resultInnerIndex = this.results.size() - 1 - (this.highestResultIndex - index);
                result = this.results.get(resultInnerIndex);
                if (result == null) {
                    result = this.calculate(index);
                }
                this.results.set(resultInnerIndex, result);
            }
        }
        return result;
    }

    protected abstract T calculate(int var1);

    private void increaseLengthTo(int index, int maxLength) {
        if (this.highestResultIndex > -1) {
            int newResultsCount = Math.min(index - this.highestResultIndex, maxLength);
            if (newResultsCount == maxLength) {
                this.results.clear();
                this.results.addAll(Collections.nCopies(maxLength, null));
            } else if (newResultsCount > 0) {
                this.results.addAll(Collections.nCopies(newResultsCount, null));
                this.removeExceedingResults(maxLength);
            }
        } else {
            assert (this.results.isEmpty()) : "Cache results list should be empty";
            this.results.addAll(Collections.nCopies(Math.min(index + 1, maxLength), null));
        }
    }

    private void removeExceedingResults(int maximumResultCount) {
        int resultCount = this.results.size();
        if (resultCount > maximumResultCount) {
            int nbResultsToRemove = resultCount - maximumResultCount;
            for (int i = 0; i < nbResultsToRemove; ++i) {
                this.results.remove(0);
            }
        }
    }
}

