/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.DirectionalMovementUpIndicator;

public class AverageDirectionalMovementUpIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final DirectionalMovementUpIndicator dmup;

    public AverageDirectionalMovementUpIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.dmup = new DirectionalMovementUpIndicator(series);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ONE;
        }
        Decimal nbPeriods = Decimal.valueOf(this.timeFrame);
        Decimal nbPeriodsMinusOne = Decimal.valueOf(this.timeFrame - 1);
        return ((Decimal)this.getValue(index - 1)).multipliedBy(nbPeriodsMinusOne).dividedBy(nbPeriods).plus(((Decimal)this.dmup.getValue(index)).dividedBy(nbPeriods));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

