/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class AverageGainIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<? extends Decimal> indicator;
    private final int timeFrame;

    public AverageGainIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal result = Decimal.ZERO;
        for (int i = Math.max(1, index - this.timeFrame + 1); i <= index; ++i) {
            if (!this.indicator.getValue(i - 1).isLessThan(this.indicator.getValue(i))) continue;
            result = result.plus(this.indicator.getValue(i).minus(this.indicator.getValue(i - 1)));
        }
        int realTimeFrame = Math.min(this.timeFrame, index + 1);
        return result.dividedBy(Decimal.valueOf(realTimeFrame));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

