/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class CrossIndicator
extends CachedIndicator<Boolean> {
    private final Indicator<? extends Decimal> up;
    private final Indicator<? extends Decimal> low;

    public CrossIndicator(Indicator<? extends Decimal> up, Indicator<? extends Decimal> low) {
        super(up);
        this.up = up;
        this.low = low;
    }

    @Override
    protected Boolean calculate(int index) {
        int i = index;
        if (i == 0 || this.up.getValue(i).isGreaterThanOrEqual(this.low.getValue(i))) {
            return false;
        }
        if (this.up.getValue(--i).isGreaterThan(this.low.getValue(i))) {
            return true;
        }
        while (i > 0 && this.up.getValue(i).isEqual(this.low.getValue(i))) {
            --i;
        }
        return i != 0 && this.up.getValue(i).isGreaterThan(this.low.getValue(i));
    }

    public Indicator<? extends Decimal> getLow() {
        return this.low;
    }

    public Indicator<? extends Decimal> getUp() {
        return this.up;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.low + " " + this.up;
    }
}

