/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class HighestValueIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<? extends Decimal> indicator;
    private final int timeFrame;

    public HighestValueIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        int start = Math.max(0, index - this.timeFrame + 1);
        Decimal highest = this.indicator.getValue(start);
        for (int i = start + 1; i <= index; ++i) {
            if (!highest.isLessThan(this.indicator.getValue(i))) continue;
            highest = this.indicator.getValue(i);
        }
        return highest;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

