/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class StandardDeviationIndicator
extends CachedIndicator<Decimal> {
    private Indicator<? extends Decimal> indicator;
    private int timeFrame;
    private SMAIndicator sma;

    public StandardDeviationIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.sma = new SMAIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int numberOfObservations = index - startIndex + 1;
        Decimal standardDeviation = Decimal.ZERO;
        Decimal average = (Decimal)this.sma.getValue(index);
        for (int i = startIndex; i <= index; ++i) {
            Decimal pow = this.indicator.getValue(i).minus(average).pow(2);
            standardDeviation = standardDeviation.plus(pow);
        }
        standardDeviation = standardDeviation.dividedBy(Decimal.valueOf(numberOfObservations));
        return standardDeviation.sqrt();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

