/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class TrueRangeIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;

    public TrueRangeIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal ts = this.series.getTick(index).getMaxPrice().minus(this.series.getTick(index).getMinPrice());
        Decimal ys = index == 0 ? Decimal.ZERO : this.series.getTick(index).getMaxPrice().minus(this.series.getTick(index - 1).getClosePrice());
        Decimal yst = index == 0 ? Decimal.ZERO : this.series.getTick(index - 1).getClosePrice().minus(this.series.getTick(index).getMinPrice());
        return ts.abs().max(ys.abs()).max(yst.abs());
    }
}

