/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.oscillators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MeanDeviationIndicator;
import eu.verdelhan.ta4j.indicators.simple.TypicalPriceIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class CCIIndicator
extends CachedIndicator<Decimal> {
    public static final Decimal FACTOR = Decimal.valueOf("0.015");
    private TypicalPriceIndicator typicalPriceInd;
    private SMAIndicator smaInd;
    private MeanDeviationIndicator meanDeviationInd;
    private int timeFrame;

    public CCIIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.typicalPriceInd = new TypicalPriceIndicator(series);
        this.smaInd = new SMAIndicator(this.typicalPriceInd, timeFrame);
        this.meanDeviationInd = new MeanDeviationIndicator(this.typicalPriceInd, timeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal typicalPrice = (Decimal)this.typicalPriceInd.getValue(index);
        Decimal typicalPriceAvg = (Decimal)this.smaInd.getValue(index);
        Decimal meanDeviation = (Decimal)this.meanDeviationInd.getValue(index);
        if (meanDeviation.isZero()) {
            return Decimal.ZERO;
        }
        return typicalPrice.minus(typicalPriceAvg).dividedBy(meanDeviation.multipliedBy(FACTOR));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

