/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.oscillators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.EMAIndicator;

public class PPOIndicator
extends CachedIndicator<Decimal> {
    private final EMAIndicator shortTermEma;
    private final EMAIndicator longTermEma;

    public PPOIndicator(Indicator<? extends Decimal> indicator, int shortTimeFrame, int longTimeFrame) {
        super(indicator);
        if (shortTimeFrame > longTimeFrame) {
            throw new IllegalArgumentException("Long term period count must be greater than short term period count");
        }
        this.shortTermEma = new EMAIndicator(indicator, shortTimeFrame);
        this.longTermEma = new EMAIndicator(indicator, longTimeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal shortEmaValue = (Decimal)this.shortTermEma.getValue(index);
        Decimal longEmaValue = (Decimal)this.longTermEma.getValue(index);
        return shortEmaValue.minus(longEmaValue).dividedBy(longEmaValue).multipliedBy(Decimal.HUNDRED);
    }
}

