/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class EMAIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<? extends Decimal> indicator;
    private final int timeFrame;
    private final Decimal multiplier;

    public EMAIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.multiplier = Decimal.TWO.dividedBy(Decimal.valueOf(timeFrame + 1));
    }

    @Override
    protected Decimal calculate(int index) {
        if (index + 1 < this.timeFrame) {
            return (Decimal)new SMAIndicator(this.indicator, this.timeFrame).getValue(index);
        }
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Decimal emaPrev = (Decimal)this.getValue(index - 1);
        return this.indicator.getValue(index).minus(emaPrev).multipliedBy(this.multiplier).plus(emaPrev);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

