/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.simple.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MinPriceIndicator;

public class ParabolicSarIndicator
extends CachedIndicator<Decimal> {
    private static final Decimal DEFAULT_ACCELERATION = Decimal.valueOf("0.02");
    private static final Decimal ACCELERATION_THRESHOLD = Decimal.valueOf("0.19");
    private static final Decimal MAX_ACCELERATION = Decimal.valueOf("0.2");
    private static final Decimal ACCELERATION_INCREMENT = Decimal.valueOf("0.02");
    private Decimal acceleration = DEFAULT_ACCELERATION;
    private final TimeSeries series;
    private Decimal extremePoint;
    private final LowestValueIndicator lowestValueIndicator;
    private final HighestValueIndicator highestValueIndicator;
    private final int timeFrame;

    public ParabolicSarIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.series = series;
        this.lowestValueIndicator = new LowestValueIndicator(new MinPriceIndicator(series), timeFrame);
        this.highestValueIndicator = new HighestValueIndicator(new MaxPriceIndicator(series), timeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal sar;
        if (index <= 1) {
            this.extremePoint = this.series.getTick(index).getClosePrice();
            return this.extremePoint;
        }
        Decimal n2ClosePrice = this.series.getTick(index - 2).getClosePrice();
        Decimal n1ClosePrice = this.series.getTick(index - 1).getClosePrice();
        Decimal nClosePrice = this.series.getTick(index).getClosePrice();
        if (n2ClosePrice.isGreaterThan(n1ClosePrice) && n1ClosePrice.isLessThan(nClosePrice)) {
            sar = this.extremePoint;
            this.extremePoint = (Decimal)this.highestValueIndicator.getValue(index);
            this.acceleration = DEFAULT_ACCELERATION;
        } else if (n2ClosePrice.isLessThan(n1ClosePrice) && n1ClosePrice.isGreaterThan(nClosePrice)) {
            sar = this.extremePoint;
            this.extremePoint = (Decimal)this.lowestValueIndicator.getValue(index);
            this.acceleration = DEFAULT_ACCELERATION;
        } else if (nClosePrice.isLessThan(n1ClosePrice)) {
            Decimal lowestValue = (Decimal)this.lowestValueIndicator.getValue(index);
            if (this.extremePoint.isGreaterThan(lowestValue)) {
                this.incrementAcceleration();
                this.extremePoint = lowestValue;
            }
            sar = this.calculateSar(index);
            Decimal n2MaxPrice = this.series.getTick(index - 2).getMaxPrice();
            Decimal n1MaxPrice = this.series.getTick(index - 1).getMaxPrice();
            Decimal nMaxPrice = this.series.getTick(index).getMaxPrice();
            if (n1MaxPrice.isGreaterThan(sar)) {
                sar = n1MaxPrice;
            } else if (n2MaxPrice.isGreaterThan(sar)) {
                sar = n2MaxPrice;
            }
            if (nMaxPrice.isGreaterThan(sar)) {
                sar = this.series.getTick(index).getMinPrice();
            }
        } else {
            Decimal highestValue = (Decimal)this.highestValueIndicator.getValue(index);
            if (this.extremePoint.isLessThan(highestValue)) {
                this.incrementAcceleration();
                this.extremePoint = highestValue;
            }
            sar = this.calculateSar(index);
            Decimal n2MinPrice = this.series.getTick(index - 2).getMinPrice();
            Decimal n1MinPrice = this.series.getTick(index - 1).getMinPrice();
            Decimal nMinPrice = this.series.getTick(index).getMinPrice();
            if (n1MinPrice.isLessThan(sar)) {
                sar = n1MinPrice;
            } else if (n2MinPrice.isLessThan(sar)) {
                sar = n2MinPrice;
            }
            if (nMinPrice.isLessThan(sar)) {
                sar = this.series.getTick(index).getMaxPrice();
            }
        }
        return sar;
    }

    private void incrementAcceleration() {
        this.acceleration = this.acceleration.isGreaterThanOrEqual(ACCELERATION_THRESHOLD) ? MAX_ACCELERATION : this.acceleration.plus(ACCELERATION_INCREMENT);
    }

    private Decimal calculateSar(int index) {
        Decimal previousSar = (Decimal)this.getValue(index - 1);
        return this.extremePoint.multipliedBy(this.acceleration).plus(Decimal.ONE.minus(this.acceleration).multipliedBy(previousSar));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

