/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageGainIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageLossIndicator;

public class RSIIndicator
extends CachedIndicator<Decimal> {
    private AverageGainIndicator averageGainIndicator;
    private AverageLossIndicator averageLossIndicator;
    private final int timeFrame;

    public RSIIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.timeFrame = timeFrame;
        this.averageGainIndicator = new AverageGainIndicator(indicator, timeFrame);
        this.averageLossIndicator = new AverageLossIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        return Decimal.HUNDRED.minus(Decimal.HUNDRED.dividedBy(Decimal.ONE.plus(this.relativeStrength(index))));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " timeFrame: " + this.timeFrame;
    }

    private Decimal relativeStrength(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal averageGain = (Decimal)this.averageGainIndicator.getValue(index);
        Decimal averageLoss = (Decimal)this.averageLossIndicator.getValue(index);
        return averageGain.dividedBy(averageLoss);
    }
}

