/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class SMAIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<? extends Decimal> indicator;
    private final int timeFrame;

    public SMAIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal sum = Decimal.ZERO;
        for (int i = Math.max(0, index - this.timeFrame + 1); i <= index; ++i) {
            sum = sum.plus(this.indicator.getValue(i));
        }
        int realTimeFrame = Math.min(this.timeFrame, index + 1);
        return sum.dividedBy(Decimal.valueOf(realTimeFrame));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

