/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class WMAIndicator
extends CachedIndicator<Decimal> {
    private int timeFrame;
    private Indicator<? extends Decimal> indicator;

    public WMAIndicator(Indicator<? extends Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Decimal value = Decimal.ZERO;
        if (index - this.timeFrame < 0) {
            for (int i = index + 1; i > 0; --i) {
                value = value.plus(Decimal.valueOf(i).multipliedBy(this.indicator.getValue(i - 1)));
            }
            return value.dividedBy(Decimal.valueOf((index + 1) * (index + 2) / 2));
        }
        int actualIndex = index;
        for (int i = this.timeFrame; i > 0; --i) {
            value = value.plus(Decimal.valueOf(i).multipliedBy(this.indicator.getValue(actualIndex)));
            --actualIndex;
        }
        return value.dividedBy(Decimal.valueOf(this.timeFrame * (this.timeFrame + 1) / 2));
    }

    @Override
    public String toString() {
        return String.format(this.getClass().getSimpleName() + " timeFrame: %s", this.timeFrame);
    }
}

