/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class AccumulationDistributionIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;

    public AccumulationDistributionIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Tick tick = this.series.getTick(index);
        Decimal moneyFlowMultiplier = tick.getClosePrice().minus(tick.getMinPrice()).minus(tick.getMaxPrice().minus(tick.getClosePrice())).dividedBy(tick.getMaxPrice().minus(tick.getMinPrice()));
        Decimal moneyFlowVolume = moneyFlowMultiplier.multipliedBy(tick.getVolume());
        return moneyFlowVolume.plus((Decimal)this.getValue(index - 1));
    }
}

