/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class OnBalanceVolumeIndicator
extends CachedIndicator<Decimal> {
    private final TimeSeries series;

    public OnBalanceVolumeIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal todayClose;
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal yesterdayClose = this.series.getTick(index - 1).getClosePrice();
        if (yesterdayClose.isGreaterThan(todayClose = this.series.getTick(index).getClosePrice())) {
            return ((Decimal)this.getValue(index - 1)).minus(this.series.getTick(index).getVolume());
        }
        if (yesterdayClose.isLessThan(todayClose)) {
            return ((Decimal)this.getValue(index - 1)).plus(this.series.getTick(index).getVolume());
        }
        return (Decimal)this.getValue(index - 1);
    }
}

