/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.strategies.AndStrategy;
import eu.verdelhan.ta4j.strategies.OppositeStrategy;
import eu.verdelhan.ta4j.strategies.OrStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStrategy
implements Strategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean shouldOperate(Trade trade, int index) {
        if (trade.isNew()) {
            return this.shouldEnter(index);
        }
        if (trade.isOpened()) {
            return this.shouldExit(index);
        }
        return false;
    }

    @Override
    public Strategy and(Strategy strategy) {
        return new AndStrategy(this, strategy);
    }

    @Override
    public Strategy or(Strategy strategy) {
        return new OrStrategy(this, strategy);
    }

    @Override
    public Strategy opposite() {
        return new OppositeStrategy(this);
    }

    protected void traceEnter(int index, boolean enter) {
        this.log.trace("{}#shouldEnter({}): {}", new Object[]{this.getClass().getSimpleName(), index, enter});
    }

    protected void traceExit(int index, boolean exit) {
        this.log.trace("{}#shouldExit({}): {}", new Object[]{this.getClass().getSimpleName(), index, exit});
    }
}

