/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class CombinedEntryAndExitStrategy
extends AbstractStrategy {
    private Strategy entryStrategy;
    private Strategy exitStrategy;

    public CombinedEntryAndExitStrategy(Strategy entryStrategy, Strategy exitStrategy) {
        this.entryStrategy = entryStrategy;
        this.exitStrategy = exitStrategy;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.entryStrategy.shouldEnter(index);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.exitStrategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("Combined strategy using entry strategy %s and exit strategy %s", this.entryStrategy, this.exitStrategy);
    }
}

