/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.simple.ConstantIndicator;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class DistanceBetweenIndicatorsStrategy
extends AbstractStrategy {
    private Indicator<? extends Decimal> upper;
    private Indicator<? extends Decimal> lower;
    private double distance;
    private double difference;

    public <T extends Decimal> DistanceBetweenIndicatorsStrategy(Indicator<? extends Decimal> indicator, T constant, double distance, double difference) {
        this.upper = indicator;
        this.lower = new ConstantIndicator<Decimal>(constant);
        this.distance = distance;
        this.difference = difference;
    }

    public DistanceBetweenIndicatorsStrategy(Indicator<? extends Decimal> upper, Indicator<? extends Decimal> lower, double distance, double difference) {
        this.upper = upper;
        this.lower = lower;
        this.distance = distance;
        this.difference = difference;
    }

    @Override
    public boolean shouldEnter(int index) {
        Decimal threshold = Decimal.valueOf((this.difference + 1.0) * this.distance);
        boolean enter = this.upper.getValue(index).minus(this.lower.getValue(index)).isGreaterThanOrEqual(threshold);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        Decimal threshold = Decimal.valueOf((1.0 - this.difference) * this.distance);
        boolean exit = this.upper.getValue(index).minus(this.lower.getValue(index)).isLessThanOrEqual(threshold);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s upper: %s lower: %s", this.getClass().getSimpleName(), this.upper, this.lower);
    }
}

