/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.helpers.CrossIndicator;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class IndicatorCrossedIndicatorStrategy
extends AbstractStrategy {
    private final Indicator<Boolean> crossUp;
    private final Indicator<Boolean> crossDown;
    private Indicator<? extends Decimal> upper;
    private Indicator<? extends Decimal> lower;

    public IndicatorCrossedIndicatorStrategy(Indicator<? extends Decimal> upper, Indicator<? extends Decimal> lower) {
        this.upper = upper;
        this.lower = lower;
        this.crossUp = new CrossIndicator(upper, lower);
        this.crossDown = new CrossIndicator(lower, upper);
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.crossUp.getValue(index);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.crossDown.getValue(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("Cross %s over %s", this.upper, this.lower);
    }
}

