/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class IndicatorOverIndicatorStrategy
extends AbstractStrategy {
    private Indicator<Decimal> first;
    private Indicator<Decimal> second;

    public IndicatorOverIndicatorStrategy(Indicator<Decimal> first, Indicator<Decimal> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.first.getValue(index).isGreaterThan(this.second.getValue(index));
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.first.getValue(index).isLessThan(this.second.getValue(index));
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s : %s over %s", this.getClass().getSimpleName(), this.first, this.second);
    }
}

