/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class MaxValueStarterStrategy
extends AbstractStrategy {
    private final Strategy strategy;
    private final Indicator<? extends Number> indicator;
    private final double start;

    public MaxValueStarterStrategy(Indicator<? extends Number> indicator, Strategy strategy, double start) {
        this.indicator = indicator;
        this.strategy = strategy;
        this.start = start;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.indicator.getValue(index).doubleValue() < this.start;
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s start: %f", this.getClass().getSimpleName(), this.start);
    }
}

