/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class MinValueStarterStrategy
extends AbstractStrategy {
    private Strategy strategy;
    private Indicator<? extends Decimal> indicator;
    private Decimal start;

    public MinValueStarterStrategy(Indicator<? extends Decimal> indicator, Strategy strategy, double start) {
        this.indicator = indicator;
        this.strategy = strategy;
        this.start = Decimal.valueOf(start);
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.indicator.getValue(index).isGreaterThan(this.start);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s start: %f", this.getClass().getSimpleName(), this.start);
    }
}

