/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class NotSoFastStrategy
extends AbstractStrategy {
    private Strategy strategy;
    private int numberOfTicks;
    private int enterTickIndex;

    public NotSoFastStrategy(Strategy strategy, int numberOfTicks) {
        this.strategy = strategy;
        this.numberOfTicks = numberOfTicks;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.strategy.shouldEnter(index);
        if (enter) {
            this.enterTickIndex = index;
        }
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = index - this.enterTickIndex > this.numberOfTicks && this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " over strategy: " + this.strategy + " number of ticks: " + this.numberOfTicks;
    }
}

