/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.helpers.CrossIndicator;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class PipeEnterStrategy
extends AbstractStrategy {
    private final Indicator<Boolean> crossUp;
    private final Indicator<Boolean> crossDown;

    public PipeEnterStrategy(Indicator<? extends Decimal> upper, Indicator<? extends Decimal> lower, Indicator<? extends Decimal> value) {
        this.crossUp = new CrossIndicator(value, upper);
        this.crossDown = new CrossIndicator(lower, value);
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.crossDown.getValue(index);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.crossUp.getValue(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s upper: %s lower: %s", this.getClass().getSimpleName(), this.crossUp, this.crossDown);
    }
}

