/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class ResistanceStrategy
extends AbstractStrategy {
    private final Strategy strategy;
    private final Indicator<? extends Decimal> indicator;
    private Decimal resistance;

    public ResistanceStrategy(Indicator<? extends Decimal> indicator, Strategy strategy, double resistance) {
        this.strategy = strategy;
        this.resistance = Decimal.valueOf(resistance);
        this.indicator = indicator;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.strategy.shouldEnter(index);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.indicator.getValue(index).isGreaterThanOrEqual(this.resistance) || this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s resistance: %f strategy: %s", this.getClass().getSimpleName(), this.resistance.toDouble(), this.strategy);
    }
}

