/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class StopGainStrategy
extends AbstractStrategy {
    private Strategy strategy;
    private Decimal gain;
    private Indicator<? extends Decimal> indicator;
    private Decimal value;

    public StopGainStrategy(Indicator<? extends Decimal> indicator, Strategy strategy, int gain) {
        this.strategy = strategy;
        this.gain = Decimal.valueOf(gain);
        this.indicator = indicator;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.strategy.shouldEnter(index);
        if (enter) {
            this.value = this.indicator.getValue(index);
        }
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.value.plus(this.value.multipliedBy(this.gain.dividedBy(Decimal.HUNDRED))).isLessThan(this.indicator.getValue(index)) || this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s stoper: %s over %s", this.getClass().getSimpleName(), "" + this.gain.toDouble(), this.strategy);
    }
}

