/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class StopLossStrategy
extends AbstractStrategy {
    private Strategy strategy;
    private Decimal loss;
    private Indicator<? extends Decimal> indicator;
    private Decimal value;

    public StopLossStrategy(Indicator<? extends Decimal> indicator, Strategy strategy, int loss) {
        this.strategy = strategy;
        this.loss = Decimal.valueOf(loss);
        this.indicator = indicator;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.strategy.shouldEnter(index);
        if (enter) {
            this.value = this.indicator.getValue(index);
        }
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.value.minus(this.value.multipliedBy(this.loss.dividedBy(Decimal.HUNDRED))).isGreaterThan(this.indicator.getValue(index)) || this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s stoper: %s over %s", this.getClass().getSimpleName(), "" + this.loss.toDouble(), this.strategy);
    }
}

