/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.strategies;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.strategies.AbstractStrategy;

public class SupportStrategy
extends AbstractStrategy {
    private final Strategy strategy;
    private final Indicator<? extends Decimal> indicator;
    private Decimal support;

    public SupportStrategy(Indicator<? extends Decimal> indicator, Strategy strategy, double support) {
        this.strategy = strategy;
        this.support = Decimal.valueOf(support);
        this.indicator = indicator;
    }

    @Override
    public boolean shouldEnter(int index) {
        boolean enter = this.support.isGreaterThanOrEqual(this.indicator.getValue(index)) || this.strategy.shouldEnter(index);
        this.traceEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index) {
        boolean exit = this.strategy.shouldExit(index);
        this.traceExit(index, exit);
        return exit;
    }

    public String toString() {
        return String.format("%s support: %f strategy: %s", this.getClass().getSimpleName(), this.support.toDouble(), this.strategy);
    }
}

