package eu.xenit.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Value object to abstract multiple values mapped by a {@link String} key.
 */
public class Values {

    private final Map<String, Object> mapValues = new HashMap<>();

    public Values() {
    }

    public Values(String name, Object value) {
        if (name != null && value != null) {
            mapValues.put(name, value);
        }
    }

    public boolean hasValues() {
        return !mapValues.isEmpty();
    }

    public int size() {
        return mapValues.size();
    }

    public Set<String> getEntryNames() {
        return Collections.unmodifiableSet(mapValues.keySet());
    }

    public void setValue(String key, Object value) {
        mapValues.put(key, value);
    }

    @SuppressWarnings("unchecked")
    public <T> T getValue(String key) {
        return (T) mapValues.get(key);
    }
}
