package eu.xenit.json.intern;

import eu.xenit.json.DynamicMdcMessageField;
import eu.xenit.json.JsonMessageAssembler;
import eu.xenit.json.LogMessageField;
import eu.xenit.json.MdcMessageField;
import eu.xenit.json.StaticMessageField;

public class ConfigurationSupport {

    public static final String MULTI_VALUE_DELIMITTER = ",";
    public static final char EQ = '=';

    private ConfigurationSupport() {
    }

    /**
     * Set the additional (static) fields.
     *
     * @param spec                 field=value,field1=value1, ...
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setAdditionalFields(String spec, JsonMessageAssembler jsonMessageAssembler) {
        if (null != spec) {
            String[] properties = spec.split(MULTI_VALUE_DELIMITTER);

            for (String field : properties) {
                final int index = field.indexOf(EQ);
                if (-1 == index) {
                    continue;
                }
                jsonMessageAssembler.addField(new StaticMessageField(field.substring(0, index), field.substring(index + 1)));
            }
        }
    }

    /**
     * Set the MDC fields.
     *
     * @param spec                 field, field2, field3
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setMdcFields(String spec, JsonMessageAssembler jsonMessageAssembler) {
        if (null != spec) {
            String[] fields = spec.split(MULTI_VALUE_DELIMITTER);

            for (String field : fields) {
                jsonMessageAssembler.addField(new MdcMessageField(field.trim(), field.trim()));
            }
        }
    }

    /**
     * Set the dynamic MDC fields.
     *
     * @param spec                 field, .*FieldSuffix, fieldPrefix.*
     * @param jsonMessageAssembler the {@link JsonMessageAssembler}.
     */
    public static void setDynamicMdcFields(String spec, JsonMessageAssembler jsonMessageAssembler) {
        if (null != spec) {
            String[] fields = spec.split(MULTI_VALUE_DELIMITTER);

            for (String field : fields) {
                jsonMessageAssembler.addField(new DynamicMdcMessageField(field.trim()));
            }
        }
    }

    /**
     * Set the additional field types.
     *
     * @param spec                 field=String,field1=Double, ... See {@link JsonMessage} for supported types.
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setAdditionalFieldTypes(String spec, JsonMessageAssembler jsonMessageAssembler) {
        if (null != spec) {
            String[] properties = spec.split(MULTI_VALUE_DELIMITTER);

            for (String field : properties) {
                final int index = field.indexOf(EQ);
                if (-1 != index) {
                    jsonMessageAssembler.setAdditionalFieldType(field.substring(0, index), field.substring(index + 1));
                }
            }
        }
    }

    /**
     * Set the dynamic mdc field types.
     *
     * @param spec                 field=String,field1=Double, ... See {@link JsonMessage} for supported types.
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setDynamicMdcFieldTypes(String spec, JsonMessageAssembler jsonMessageAssembler) {
        if (null != spec) {
            String[] properties = spec.split(MULTI_VALUE_DELIMITTER);

            for (String field : properties) {
                final int index = field.indexOf(EQ);
                if (-1 != index) {
                    jsonMessageAssembler.setDynamicMdcFieldType(field.substring(0, index), field.substring(index + 1));
                }
            }
        }
    }

    /**
     * Set the additional (static) fields.
     *
     * @param type                 application, access ...
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setType(String type, JsonMessageAssembler jsonMessageAssembler) {
        if (null != type) {
            jsonMessageAssembler.addField(new StaticMessageField(LogMessageField.NamedLogField.Type.getFieldName(), type));
        }
    }

    /**
     * Set the additional (static) fields.
     *
     * @param component            docker-entrypoint, alfresco, share, tomcat ...
     * @param jsonMessageAssembler the Json message assembler to apply the configuration
     */
    public static void setComponent(String component, JsonMessageAssembler jsonMessageAssembler) {
        if (null != component) {
            jsonMessageAssembler.addField(new StaticMessageField(LogMessageField.NamedLogField.Component.getFieldName(), component));
        }
    }

}
