package eu.xenit.json.intern;

import java.io.Closeable;

/**
 * Strategy interface to send a {@link JsonMessage} without being opinionated about the underlying transport.
 */
public interface JsonSender extends Closeable {

    /**
     * Send the Json message.
     *
     * @param message the message
     * @return {@literal true} if the message was sent
     */
    boolean sendMessage(JsonMessage message);

    /**
     * Close the sender and free resources.
     */
    void close();
}
