package eu.xenit.json.intern;

import java.util.Map;

/**
 * Configuration for a Json Sender.
 */
public interface JsonSenderConfiguration {

    /**
     * @return the host part (can be any arbitrary string which is supported by the JsonSender)
     */
    String getHost();

    /**
     * @return port number (optional, 0 if not provided)
     */
    int getPort();

    /**
     * @return the ErrorReporter to report any errors
     */
    ErrorReporter getErrorReporter();

    /**
     * @return some sender specific configurations
     */
    Map<String, Object> getSpecificConfigurations();
}
