package eu.xenit.json.intern;

import java.io.IOException;

/**
 * Strategy interface to create a {@link JsonSender}. Implementations decide based on the {@code host} string whether they
 * support {@link JsonSender} creation.
 */
public interface JsonSenderProvider {

    /**
     * @param host the host string
     * @return true if the host scheme/pattern/uri is supported by this provider.
     */
    boolean supports(String host);

    /**
     * Create the sender based on the passed configuration.
     *
     * @param configuration the sender configuration
     * @return JsonSender instance.
     * @throws IOException if there is an error in the underlying protocol
     */
    JsonSender create(JsonSenderConfiguration configuration) throws IOException;
}
