package eu.xenit.json.intern;

/**
 * {@link ErrorReporter} that post-processes the error message if it is {@code null} by using the exception class name as
 * fallback.
 */
public class MessagePostprocessingErrorReporter implements ErrorReporter {

    private final ErrorReporter delegate;

    public MessagePostprocessingErrorReporter(ErrorReporter delegate) {
        this.delegate = delegate;
    }

    private static String postProcessMessage(String message, Exception e) {

        if ((message == null || "null".equalsIgnoreCase(message)) && e != null) {

            if (e.getMessage() != null) {
                return e.getMessage();
            }

            return e.getClass().getSimpleName();
        }

        return message;
    }

    @Override
    public void reportError(String message, Exception e) {

        String messageToUse = postProcessMessage(message, e);

        delegate.reportError(messageToUse, e);
    }
}
