package eu.xenit.json.intern.sender;

import eu.xenit.json.intern.ErrorReporter;
import eu.xenit.json.intern.JsonMessage;
import eu.xenit.json.intern.JsonSender;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * {@link JsonSender} using Kafka.
 */
public class KafkaJsonSender implements JsonSender {

    private final KafkaProducer<byte[], byte[]> kafkaProducer;
    private final String topicName;
    private final ErrorReporter errorReporter;

    public KafkaJsonSender(KafkaProducer<byte[], byte[]> kafkaProducer, String topicName, ErrorReporter errorReporter) {
        this.kafkaProducer = kafkaProducer;
        this.topicName = topicName;
        this.errorReporter = errorReporter;
    }

    @Override
    public boolean sendMessage(JsonMessage message) {
        ProducerRecord<byte[], byte[]> producerRecord = new ProducerRecord<>(topicName,
                message.toJson().getBytes(StandardCharsets.UTF_8));
        boolean hasOffset;
        try {
            Future<RecordMetadata> metadata = kafkaProducer.send(producerRecord);
            hasOffset = metadata.get(30, TimeUnit.SECONDS).hasOffset();
        } catch (Exception e) {
            errorReporter.reportError("Error sending log to kafka", e);
            return false;
        }
        return hasOffset;
    }

    @Override
    public void close() {
        kafkaProducer.close();
    }
}
