package eu.xenit.json.intern.sender;

import eu.xenit.json.intern.JsonSender;
import eu.xenit.json.intern.JsonSenderConfiguration;
import eu.xenit.json.intern.JsonSenderProvider;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.Pool;

import java.io.IOException;
import java.net.URI;

/**
 * {@link JsonSenderProvider} to provide {@link JsonREDISSender}.
 */
public class RedisJsonSenderProvider implements JsonSenderProvider {

    @Override
    public boolean supports(String host) {
        return host.startsWith(RedisSenderConstants.REDIS_SCHEME + ":")
                || host.startsWith(RedisSenderConstants.REDIS_SENTINEL_SCHEME + ":");
    }

    @Override
    public JsonSender create(JsonSenderConfiguration configuration) throws IOException {

        String host = configuration.getHost();

        URI hostUri = URI.create(host);
        int port = hostUri.getPort();
        if (port <= 0) {
            port = configuration.getPort();
        }

        if (port <= 0) {
            port = Protocol.DEFAULT_PORT;
        }

        if (hostUri.getFragment() == null || hostUri.getFragment().trim().equals("")) {
            throw new IllegalArgumentException("Redis URI must specify fragment");
        }

        if (hostUri.getHost() == null) {
            throw new IllegalArgumentException("Redis URI must specify host");
        }

        Pool<Jedis> pool = RedisPoolHolder.getInstance().getJedisPool(hostUri, port);
        return new JsonREDISSender(pool, hostUri.getFragment(), configuration.getErrorReporter());
    }
}
