package eu.xenit.json.jul;

import eu.xenit.json.PropertyProvider;

import java.util.logging.LogManager;


public class JulPropertyProvider implements PropertyProvider {

    private final String prefix;
    private final LogManager logManager;

    public JulPropertyProvider(Class<?> configurationBase) {
        prefix = configurationBase.getName();
        logManager = LogManager.getLogManager();

    }

    @Override
    public String getProperty(String propertyName) {
        return logManager.getProperty(prefix + "." + propertyName);
    }
}
