package eu.xenit.json.log4j2;

import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.util.Strings;

import java.util.regex.Pattern;

/**
 * Configuration for dynamic log fields pulled from MDC.
 */
@Plugin(name = "DynamicMdcFieldType", category = "Core", printObject = true)
public class JsonDynamicMdcFieldType {

    private final Pattern pattern;
    private final String type;

    public JsonDynamicMdcFieldType(Pattern pattern, String type) {
        this.pattern = pattern;
        this.type = type;
    }

    @PluginFactory
    public static JsonDynamicMdcFieldType createField(@PluginAttribute("regex") String regex,
                                                      @PluginAttribute("type") String type) {

        if (Strings.isEmpty(regex)) {
            throw new IllegalArgumentException("Regex is empty");
        }

        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("Type is empty");
        }

        return new JsonDynamicMdcFieldType(Pattern.compile(regex), type);
    }

    public Pattern getPattern() {
        return pattern;
    }

    public String getType() {
        return type;
    }
}
