package eu.xenit.json.standalone;

import eu.xenit.json.intern.JsonMessage;

import java.util.Map;

/**
 * Datenpumpe allows to submit arbitrary values (flat data set) using Json.
 */
public interface Datenpumpe {
    /**
     * Submit a map of key-value pairs using Json.
     *
     * @param data map containing the data, must not be {@literal null}
     */
    void submit(Map<String, Object> data);

    /**
     * Submit a JsonMessage.
     *
     * @param jsonMessage the message, must not be {@literal null}
     */
    void submit(JsonMessage jsonMessage);

    /**
     * Submit a Java bean. All accessible fields will be used in a property manner to submit the data.
     *
     * @param javaBean the java bean, must not be {@literal null}
     */
    void submit(Object javaBean);
}
