package eu.xenit.json.standalone;

import eu.xenit.json.JsonMessageBuilder;
import eu.xenit.json.intern.JsonMessage;
import eu.xenit.json.intern.JsonSender;
import eu.xenit.json.intern.JsonSenderConfiguration;
import eu.xenit.json.intern.JsonSenderFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Default implementation of {@link Datenpumpe}.
 */
public class DatenpumpeImpl implements Datenpumpe {

    private final JsonSenderConfiguration jsonSenderConfiguration;

    private final Object mutex = new Object();

    private volatile JsonSender jsonSender = null;

    public DatenpumpeImpl(JsonSenderConfiguration jsonSenderConfiguration) {
        this.jsonSenderConfiguration = jsonSenderConfiguration;
    }

    @Override
    public void submit(Map<String, Object> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data map must not be null");
        }
        Map<String, String> fields = new HashMap<>();

        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                continue;
            }

            fields.put(entry.getKey(), entry.getValue().toString());
        }

        JsonMessage jsonMessage = JsonMessageBuilder.newInstance().withJavaTimestamp(System.currentTimeMillis())
                .withFields(fields).build();
        submit(jsonMessage);
    }

    @Override
    public void submit(JsonMessage jsonMessage) {
        if (jsonMessage == null) {
            throw new IllegalArgumentException("JsonMessage must not be null");
        }

        if (jsonSender == null) {
            synchronized (mutex) {
                if (jsonSender == null) {
                    jsonSender = JsonSenderFactory.createSender(jsonSenderConfiguration);
                }
            }
        }

        jsonSender.sendMessage(jsonMessage);

    }

    @Override
    public void submit(Object javaBean) {
        if (javaBean == null) {
            throw new IllegalArgumentException("Passed object must not be null");
        }

        Map<String, Object> fields = BeanPropertyExtraction.extractProperties(javaBean);

        submit(fields);
    }

    public void close() {
        if (jsonSender != null) {
            synchronized (mutex) {
                if (jsonSender != null) {
                    jsonSender.close();
                    jsonSender = null;
                }
            }
        }
    }
}
