package eu.xenit.json.standalone;

import eu.xenit.json.intern.ErrorReporter;
import eu.xenit.json.intern.JsonSenderConfiguration;
import eu.xenit.json.intern.MessagePostprocessingErrorReporter;

import java.util.HashMap;
import java.util.Map;

/**
 * Default json sender configuration for standalone use.
 */
public class DefaultJsonSenderConfiguration implements JsonSenderConfiguration {

    protected Map<String, Object> specificConfigurations = new HashMap<>();
    private ErrorReporter errorReporter;
    private String host;
    private int port;

    public DefaultJsonSenderConfiguration() {
        errorReporter = new MessagePostprocessingErrorReporter(new Slf4jErrorReporter());
    }

    public DefaultJsonSenderConfiguration(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Map<String, Object> getSpecificConfigurations() {
        return specificConfigurations;
    }

    public void setSpecificConfigurations(Map<String, Object> specificConfigurations) {
        this.specificConfigurations = specificConfigurations;
    }

}
