package eu.xenit.json.standalone;

import eu.xenit.json.intern.ErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jErrorReporter implements ErrorReporter {
    private Logger logger;

    public Slf4jErrorReporter() {
        logger = LoggerFactory.getLogger(getClass());
    }

    public Slf4jErrorReporter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void reportError(String message, Exception e) {
        logger.warn(message, e);
    }
}
