package eu.xenit.json.valve;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.catalina.AccessLog;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

import javax.servlet.ServletException;
import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static eu.xenit.json.XenitJsonUtil.formatLocalDateTime;
import static eu.xenit.json.XenitJsonUtil.getTimestamp;

public class JsonAccessLogValve extends ValveBase implements AccessLog {
    public JsonAccessLogValve() {
        this.printStream = System.out;
    }

    private boolean requestAttributesEnabled = false;
    private PrintStream printStream;

    @Override
    public void log(Request request, Response response, long duration) {
        Map<String, Object> root = new HashMap<>();
        LocalDateTime localDateTime = LocalDateTime.now();
        String query = request.getQueryString();
        root.put("time", formatLocalDateTime(localDateTime));
        root.put("timestamp", getTimestamp(localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli()));
        root.put("responseStatus", response.getStatus());
        root.put("type", "access");
        root.put("requestTime", getTimestamp(duration));
        root.put("requestMethod", request.getMethod());
        root.put("remoteAddr", request.getRemoteHost());
        root.put("requestUri", request.getRequestURI() +
                (Objects.isNull(query) || query.isEmpty() ? "" : "?" + query));
        try {
            getPrintStream().println(new ObjectMapper().writeValueAsString(root));
        } catch (IOException e) {
            e.printStackTrace(getPrintStream());
        }
    }


    @Override
    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = requestAttributesEnabled;
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return requestAttributesEnabled;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        getNext().invoke(request, response);
    }

    public PrintStream getPrintStream() {
        return printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }
}
