/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin;

import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import fi.evolver.ai.vaadin.view.AdminView;
import fi.evolver.ai.vaadin.view.ProfileView;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAppConfigurator
implements VaadinServiceInitListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAppConfigurator.class);

    protected abstract Class<? extends RouterLayout> getLayout();

    protected ErrorHandler getErrorHandler() {
        return null;
    }

    public void serviceInit(ServiceInitEvent event) {
        event.getSource().addSessionInitListener((SessionInitListener & Serializable)initEvent -> {
            LOG.debug("Setting up evolver-ai-vaadin routes");
            RouteConfiguration.forSessionScope().setRoute("profile", ProfileView.class, List.of(this.getLayout()));
            RouteConfiguration.forSessionScope().setRoute("admin", AdminView.class, List.of(this.getLayout()));
            ErrorHandler errorHandler = this.getErrorHandler();
            if (errorHandler != null) {
                LOG.debug("Attaching custom error handler");
                VaadinSession.getCurrent().setErrorHandler(errorHandler);
            }
        });
    }
}

