/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin;

import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.basics.spring.job.ResultState;
import fi.evolver.basics.spring.triggerable.AbstractTriggerable;
import fi.evolver.basics.spring.triggerable.TriggerableException;
import fi.evolver.utils.arg.Arg;
import fi.evolver.utils.arg.IntArg;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ChatMessageCleaner
extends AbstractTriggerable {
    private static final IntArg ARG_MAX_AGE_DAYS = new IntArg("MaxAgeDays");
    private final ChatRepository chatRepository;

    public ChatMessageCleaner(ChatRepository chatRepository) {
        this.chatRepository = chatRepository;
    }

    protected ResultState run(Map<String, Object> args) throws TriggerableException {
        int timeToLiveDays = (Integer)ARG_MAX_AGE_DAYS.get(args);
        int deletedCount = this.chatRepository.deleteByStartTimeLessThanAndFavorite(LocalDateTime.now().minusDays(timeToLiveDays), false);
        this.LOG.debug("Deleted {} chat rows older than {} day(s) and not favorited", (Object)deletedCount, (Object)timeToLiveDays);
        return ResultState.ok((String)"Deleted %d chat rows".formatted(deletedCount), (Object[])new Object[0]);
    }

    public List<Arg<?>> getArgs() {
        return Arrays.asList(ARG_MAX_AGE_DAYS);
    }
}

