/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin;

import fi.evolver.ai.vaadin.UserProfileRepository;
import fi.evolver.ai.vaadin.entity.UserProfile;
import fi.evolver.utils.attribute.ContextAttribute;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProfileService {
    private static final ContextAttribute<UserProfile> CONTEXT_USER_PROFILE = new ContextAttribute("%s.userProfile".formatted(UserProfileService.class.getSimpleName()), UserProfile.class);
    private final UserProfileRepository userProfileRepository;

    @Autowired
    public UserProfileService(UserProfileRepository userProfileRepository) {
        this.userProfileRepository = userProfileRepository;
    }

    private UserProfile fetchUserProfile() {
        return (UserProfile)CONTEXT_USER_PROFILE.computeIfAbsent(() -> this.userProfileRepository.findOrCreateUserProfile());
    }

    public Optional<String> getParameter(String key) {
        UserProfile profile = this.fetchUserProfile();
        if (profile == null) {
            return Optional.empty();
        }
        return profile.getParameter(key);
    }

    public void setParameter(String key, String value) {
        UserProfile profile = this.fetchUserProfile();
        profile.setParameter(key, value);
        this.userProfileRepository.save(profile);
    }
}

